function StartBelagerung()
	--Lade Ausenbasen per externem Skript
	--Starte Briefing: Zeige Camps, eventuelle neue Stimmen, Briefing Texte, Zeit runterlaufen lassen bis zur Durchbrechung der Belagerung
	--Tore auf, Mauern zum Spieler 1 wechseln. Angriffe aus Camps
	IncludeLocals("Belagerungsskript")
	--SetupBelagerung()
	HPTheleyNvWalls()
	SetupCampDefenderArmys()
end

function HPTheleyNvWalls()
    for i = 1, 33 ,1 do
        SetHealth("WallNvTheley_"..i, 30)
    end
end

function SetupCampDefenderArmys()
	--[[
	NVMainBaseHillSpawner
	NVMainBaseSpawner1
	NVMainBaseSpawner2
	NVMainBaseSpawner3
	NVMainBaseSpawner4
	NVMainBaseSpawner5
	NVMainBaseSpawner6
	NVMainBaseSpawner7
	NVMainBaseSpawnerTower1
	NVMainBaseSpawnerTower2
	NVMainBaseSpawnerChurch
	NVMainBaseHQ
	
	MainBaseRightTowerSpawn
	MainBaseLeftTowerSpawn
	MainBaseHillSpawn
	MainBaseYardSpawn
	MainBaseHQSpawn
	MainBaseBuildingsSpawn
	MainBaseChurchSpawn
	MainBaseTowerRuinsSpawn
	MainBaseResidenceSpawn
	------------------------------------------------------
	NVStreetDef1 Gebäude
	PassRechtsSpawn Punkt
	NVStreetDef2 Gebäude
	PassLinksSpawn Punkt
	
	PassDefPoint Def-Punkt
	
	------------------------------------------------------
	NVSpawnerWest1
	NVSpawnerWest2
	NVSpawnerWest3
	NVSpawnerWest4
	
	BaseWestDefPoint
	BaseWestSpawn
	
	------------------------------------------------------
	NVSpawnerNorth1
	NVSpawnerNorth2
	NVSpawnerNorth3
	NVSpawnerNorth4
	NVSpawnerNorth5
	
	NorthBaseLeftSpawn
	NorthBaseMiddleSpawn
	NorthBaseBackSpawn
	
	NorthBaseLeftDefPoint
	NorthBaseRightDefPoint
	
	-------------------------------------------------------
	NVSpawnerSouth1
	NVSpawnerSouth2
	NVSpawnerSouth3
	NVSpawnerSouth4
	
	SouthBaseMainEntranceSpawn
	SouthBaseSecondEntranceSpawn
	SouthRightTowerSpawn
	SouthLeftTowerSpawn
	]]
	PassDefUA = UnlimitedArmy:New({
					Player = 6,
					Area = 3000,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					AIActive = true,
					})
	local passspawnpos = {}
	passspawnpos[1] = GetPosition("PassLinksSpawn")
	passspawnpos[1].Generator = "NVStreetDef2"
	passspawnpos[2] = GetPosition("PassRechtsSpawn")
	passspawnpos[2].Generator = "NVStreetDef1"
	PassDefUASpawner = UnlimitedArmySpawnGenerator:New(PassDefUA,{
						Position = passspawnpos,
						ArmySize = 10,
						SpawnCounter = 30,
						SpawnLeaders = 10,
						LeaderDesc = {
						{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3},
						{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3}
						},
						RandomizeSpawnPoint = true
						})
	PassDefUA.DefPos = GetPosition("PassDefPoint")
	PassDefUA.DefendArea = 6000
	PassDefUA.CommandDelayer = 1
	PassDefUA:AddCommandLuaFunc(ControllDefenders,true)
	
	WestBaseUADef = UnlimitedArmy:New({
						Player = 6,
						Area = 3500,
						AutoDestroyIfEmpty = true,
						TransitAttackMove = true,
						Formation = UnlimitedArmy.Formations.Chaotic,
						AIActive = true,
						})
	local passspawnposwest = {}
	passspawnposwest[1] = GetPosition("BaseWestSpawn")
	passspawnposwest[1].Generator = {"NVSpawnerWest1","NVSpawnerWest2","NVSpawnerWest3","NVSpawnerWest4"}
	WestBaseUADefSpawnGenerator = UnlimitedArmySpawnGenerator:New(WestBaseUADef,{
							Position = passspawnposwest,
							ArmySize = 12,
							SpawnCounter = 30,
							SpawnLeaders = 12,
							LeaderDesc = {
							{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3},
							{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3}
							}
							})
	WestBaseUADef.DefPos = GetPosition("BaseWestDefPoint")
	WestBaseUADef.DefendArea = 5000
	WestBaseUADef.CommandDelayer = 1
	WestBaseUADef:AddCommandLuaFunc(ControllDefenders,true)
	SouthDefUA = UnlimitedArmy:New({
					Player = 6,
					Area = 3500,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					AIActive = true,
					})
					
	local southbase = {}
	southbase[1] = GetPosition("SouthBaseMainEntranceSpawn")
	southbase[1].Generator = "NVSpawnerSouth1"
	southbase[2] = GetPosition("SouthBaseSecondEntranceSpawn")
	southbase[2].Generator = "NVSpawnerSouth4"
	southbase[3] = GetPosition("SouthRightTowerSpawn")
	southbase[3].Generator = "NVSpawnerSouth2"
	southbase[4] = GetPosition("SouthLeftTowerSpawn")
	southbase[4].Generator = "NVSpawnerSouth3"
	SouthDefUASpawnGenerator = UnlimitedArmySpawnGenerator:New(SouthDefUA,{
							Position = southbase,
							ArmySize = 10,
							SpawnCounter = 30,
							SpawnLeaders = 10,
							LeaderDesc = {
							{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3},
							{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3}
							},
							RandomizeSpawnPoint = true
							})
	SouthDefUA.DefPos = GetPosition("SouthRightTowerSpawn")
	SouthDefUA.DefendArea = 5000
	SouthDefUA.CommandDelayer = 2
	SouthDefUA:AddCommandLuaFunc(ControllDefenders,true)
	NorthDefLeft  = UnlimitedArmy:New({
						Player = 6,
						Area = 3500,
						AutoDestroyIfEmpty = true,
						TransitAttackMove = true,
						Formation = UnlimitedArmy.Formations.Chaotic,
						AIActive = true,
						})
	NorthDefRight = UnlimitedArmy:New({
						Player = 6,
						Area = 3500,
						AutoDestroyIfEmpty = true,
						TransitAttackMove = true,
						Formation = UnlimitedArmy.Formations.Chaotic,
						AIActive = true,
						})
	local northbase = {}
	northbase[1] = GetPosition("NorthBaseLeftSpawn")
	northbase[1].Generator = {"NVSpawnerNorth1","NVSpawnerNorth2"}
	northbase[2] = GetPosition("NorthBaseMiddleSpawn")
	northbase[2].Generator = {"NVSpawnerNorth1","NVSpawnerNorth3"}
	northbase[3] = GetPosition("NorthBaseBackSpawn")
	northbase[3].Generator = {"NVSpawnerNorth4","NVSpawnerNorth5"}
	NorthDefLeftSpawnGenerator = UnlimitedArmySpawnGenerator:New(NorthDefLeft,{
							Position = northbase,
							ArmySize = 10,
							SpawnCounter = 30,
							SpawnLeaders = 10,
							LeaderDesc = {
							{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3},
							{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3}
							},
							RandomizeSpawnPoint = true
							})
	NorthDefRightSpawnGenerator = UnlimitedArmySpawnGenerator:New(NorthDefRight,{
							Position = northbase,
							ArmySize = 10,
							SpawnCounter = 30,
							SpawnLeaders = 10,
							LeaderDesc = {
							{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3},
							{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3}
							},
							RandomizeSpawnPoint = true
							})
	NorthDefLeft.DefPos = GetPosition("NorthBaseLeftDefPoint")
	NorthDefLeft.DefendArea = 5000
	NorthDefLeft.CommandDelayer = 3
	NorthDefRight.DefPos = GetPosition("NorthBaseRightDefPoint")
	NorthDefRight.DefendArea = 7000
	NorthDefRight.CommandDelayer = 3
	NorthDefLeft:AddCommandLuaFunc(ControllDefenders,true)
	NorthDefRight:AddCommandLuaFunc(ControllDefenders,true)
	
	MainBaseDefLeftUA = UnlimitedArmy:New({
						Player = 6,
						Area = 4200,
						AutoDestroyIfEmpty = true,
						TransitAttackMove = true,
						Formation = UnlimitedArmy.Formations.Chaotic,
						AIActive = true,
						})
	MainBaseDefRightUA = UnlimitedArmy:New({
						Player = 6,
						Area = 4200,
						AutoDestroyIfEmpty = true,
						TransitAttackMove = true,
						Formation = UnlimitedArmy.Formations.Chaotic,
						AIActive = true,
						})
	local mainbasespawns = {}
	mainbasespawns[1] = GetPosition("MainBaseHQSpawn")
	mainbasespawns[1].Generator = "NVMainBaseHQ"
	mainbasespawns[2] = GetPosition("MainBaseYardSpawn")
	mainbasespawns[2].Generator = "NVMainBaseSpawner4"
	mainbasespawns[3] = GetPosition("MainBaseHillSpawn")
	mainbasespawns[3].Generator = "NVMainBaseHillSpawner"
	mainbasespawns[4] = GetPosition("MainBaseRightTowerSpawn")
	mainbasespawns[4].Generator = {"NVMainBaseSpawnerTower1","NVMainBaseSpawnerTower2"}
	mainbasespawns[5] = GetPosition("MainBaseBuildingsSpawn")
	mainbasespawns[5].Generator = {"NVMainBaseSpawner2","NVMainBaseSpawner3","NVMainBaseSpawner5"}
	mainbasespawns[6] = GetPosition("MainBaseChurchSpawn")
	mainbasespawns[6].Generator = "NVMainBaseSpawnerChurch"
	mainbasespawns[7] = GetPosition("MainBaseResidenceSpawn")
	mainbasespawns[7].Generator = "NVMainBaseSpawner1"
	mainbasespawns[8] = GetPosition("MainBaseTowerRuinsSpawn")
	mainbasespawns[8].Generator = {"NVMainBaseSpawner7","NVMainBaseSpawner6"}
	
	MainBaseDefLeftUASpawnGenerator = UnlimitedArmySpawnGenerator:New(MainBaseDefLeftUA,{
								Position = mainbasespawns,
								ArmySize = 10,
								SpawnCounter = 30,
								SpawnLeaders = 10,
								LeaderDesc = {
								{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3},
								{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3}
								},
								RandomizeSpawnPoint = true
								})
	MainBaseDefRightUASpawnGenerator = UnlimitedArmySpawnGenerator:New(MainBaseDefRightUA,{
								Position = mainbasespawns,
								ArmySize = 10,
								SpawnCounter = 30,
								SpawnLeaders = 10,
								LeaderDesc = {
								{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3},
								{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 3, Looped = true, Experience = 3}
								},
								RandomizeSpawnPoint = true
								})
	MainBaseDefLeftUA.DefPos = GetPosition("WallNvTheley_19")
	MainBaseDefLeftUA.DefendArea = 9500
	MainBaseDefLeftUA.CommandDelayer = 5
	MainBaseDefRightUA.DefPos = GetPosition("WallNvTheley_31")
	MainBaseDefRightUA.DefendArea = 9500
	MainBaseDefRightUA.CommandDelayer = 4
	MainBaseDefLeftUA:AddCommandLuaFunc(ControllDefenders,true) 
	MainBaseDefRightUA:AddCommandLuaFunc(ControllDefenders,true)
	CreateAttackerArmies()
end

function ControllDefenders(self)
	if self.CommandDelayer >= 0 then
		self.CommandDelayer = self.CommandDelayer -1
		return false
	else
		self.CommandDelayer = 5
	end
	local armyPos = self:GetPosition()
	if GetSimpleDistanceSquared(armyPos,self.DefPos) >= self.DefendArea^2 then
		if self.Status ~= UnlimitedArmy.Status.MovingNoBattle then
			return false, UnlimitedArmy.CreateCommandFlee(self.DefPos)
		end
	else
		if self.Status ~= UnlimitedArmy.Status.Battle then
			if GetSimpleDistanceSquared(armyPos,self.DefPos) >= 90000 then
				return false, UnlimitedArmy.CreateCommandMove(self.DefPos)
			end
		end
	end
	return false
end

function CreateAttackerArmies()
	SouthAttackerUA = LazyUnlimitedArmy:New({
						Player = 6,
						Area = 4000,
						TransitAttackMove = true,
						Formation = UnlimitedArmy.Formations.Chaotic,
						AIActive = true,
						HiResJob = true
						},
						2,
						10)
	NorthAttackerUA = LazyUnlimitedArmy:New({
						Player = 6,
						Area = 4000,
						TransitAttackMove = true,
						Formation = UnlimitedArmy.Formations.Chaotic,
						AIActive = true,
						HiResJob = true
						},
						4,
						10)
	MainAttackerUA = LazyUnlimitedArmy:New({
						Player = 6,
						Area = 4000,
						TransitAttackMove = true,
						Formation = UnlimitedArmy.Formations.Chaotic,
						AIActive = true,
						HiResJob = true
						},
						6,
						10)
	WestAttackerUA = LazyUnlimitedArmy:New({
						Player = 6,
						Area = 4000,
						TransitAttackMove = true,
						Formation = UnlimitedArmy.Formations.Chaotic,
						AIActive = true,
						HiResJob = true
						},
						8,
						10)
	troopspawncounter = 10
	destroiedBases = 0
	troopspawncountertable = {}
	troopspawncountertable[10] = 10
	troopspawncountertable[20] = 14
	troopspawncountertable[30] = 20
	troopspawncountertable[40] = 40
	troopspawncooldowntable = {}
	troopspawncooldowntable[10] = 120
	troopspawncooldowntable[20] = 100
	troopspawncooldowntable[30] = 80
	troopspawncooldowntable[40] = 60
	SouthAttackerUA.SpawnCounter = 0
	SouthAttackerUA.giftreiter = 0
	SouthAttackerUA.dead = false
	NorthAttackerUA.SpawnCounter = 8
	NorthAttackerUA.giftreiter = 2
	NorthAttackerUA.dead = false
	MainAttackerUA.SpawnCounter = 16
	MainAttackerUA.giftreiter = 3
	MainAttackerUA.dead = false
	WestAttackerUA.SpawnCounter = 24
	WestAttackerUA.giftreiter = 4
	WestAttackerUA.dead = false
	
	SouthAttackerUA.troopcounter = 0
	WestAttackerUA.troopcounter = 0
	MainAttackerUA.troopcounter = 0
	NorthAttackerUA.troopcounter = 0
	
	SouthAttackerUA.SpawnerBuildings = 
	{{"NVSpawnerSouth1","SouthBaseMainEntranceSpawn"},
	{"NVSpawnerSouth2","SouthRightTowerSpawn"},
	{"NVSpawnerSouth3","SouthLeftTowerSpawn"},
	{"NVSpawnerSouth4","SouthBaseSecondEntranceSpawn"}}
	NorthAttackerUA.SpawnerBuildings = 
	{{"NVSpawnerNorth1","NorthBaseMiddleSpawn"},
	{"NVSpawnerNorth2","NorthBaseLeftSpawn"},
	{"NVSpawnerNorth3","NorthBaseLeftSpawn"},
	{"NVSpawnerNorth4","NorthBaseBackSpawn"},
	{"NVSpawnerNorth5","NorthBaseBackSpawn"}}
	MainAttackerUA.SpawnerBuildings =
	{{"NVMainBaseHillSpawner","MainBaseHillSpawn"},
	{"NVMainBaseSpawner1","MainBaseResidenceSpawn"},
	{"NVMainBaseSpawner2","MainBaseBuildingsSpawn"},
	{"NVMainBaseSpawner3","MainBaseBuildingsSpawn"},
	{"NVMainBaseSpawner4","MainBaseYardSpawn"},
	{"NVMainBaseSpawner5","MainBaseBuildingsSpawn"},
	{"NVMainBaseSpawner6","MainBaseTowerRuinsSpawn"},
	{"NVMainBaseSpawner7","MainBaseTowerRuinsSpawn"},
	{"NVMainBaseSpawnerTower1","MainBaseRightTowerSpawn"},
	{"NVMainBaseSpawnerTower2","MainBaseLeftTowerSpawn"},
	{"NVMainBaseSpawnerChurch","MainBaseChurchSpawn"},
	{"NVMainBaseHQ","MainBaseHQSpawn"}}
	WestAttackerUA.SpawnerBuildings =
	{{"NVStreetDef2","PassLinksSpawn"},
	{"NVStreetDef1","PassRechtsSpawn"},
	{"NVSpawnerWest1","BaseWestSpawn"},
	{"NVSpawnerWest2","BaseWestSpawn"},
	{"NVSpawnerWest3","BaseWestSpawn"},
	{"NVSpawnerWest4","BaseWestSpawn"}
	}
	
	Trigger.RequestTrigger(Events.LOGIC_EVENT_EVERY_SECOND,nil,"PoisenThrower",1,nil,nil)
	PoisonPos = {}
	giftreiter = {}
	PoisonCounter = 1
	GUIQuestTools.StartQuestInformation("NephTower", "Zu zerstörende Lager:", 1, 1)
	GUIQuestTools.UpdateQuestInformationString(destroiedBases .." / "..4)
	CreateBriefingSiege()
end

function PoisenThrower()
	for j = table.getn(PoisonPos),1,-1 do
		local giftspot = PoisonPos[j]
		if giftspot.Dauer > 0 then
			for id,_ in pairs(Player1Units) do
				if GetSimpleDistanceSquared(giftspot,GetPosition(id)) < 360000 then
					if Logic.IsLeader(id) == 1 then
						local soldiers = {Logic.GetSoldiersAttachedToLeader(id)}
						local dmg = (soldiers[1])*(Logic.GetEntityMaxHealth(soldiers[2])*0.33)+Logic.GetEntityMaxHealth(id)*0.33
						if soldiers[1] > 0 then
							local changedDmg
							for i = soldiers[1]+1,2,-1 do
								local currentHP = Logic.GetEntityHealth(soldiers[i])
								changedDmg = math.min(currentHP,dmg)
								Logic.HurtEntity(soldiers[i],changedDmg)
								dmg = dmg - changedDmg
								if dmg <= 0 then
									break;
								end
							end
						end
						Logic.HurtEntity(id,dmg)
					else
						Logic.HurtEntity(id,Logic.GetEntityMaxHealth(id)*0.33)
					end
				end
			end
			giftspot.Dauer = giftspot.Dauer - 1
		else
			table.remove(PoisonPos,j)
		end
	end
	for j = table.getn(giftreiter),1,-1 do
		if IsAlive(giftreiter[j].ID) then
			if giftreiter[j].PoisonCounter <= 0 then
				local _x,_y = Logic.GetEntityPosition(giftreiter[j].ID)
				table.insert(PoisonPos, {X=_x;Y=_y;Dauer=20})
				Logic.CreateEffect(GGL_Effects.FXKalaPoison,_x,_y,0)

				giftreiter[j].PoisonCounter = 2
				return false
			else
				giftreiter[j].PoisonCounter = PoisonCounter - 1
			end
		else
			table.remove(giftreiter,j)
		end
	end
	return false
end

function GetSimpleDistanceSquared(_pos1,_pos2)
	return (_pos1.X - _pos2.X)^2 + (_pos1.Y - _pos2.Y)^2
end

function PlayerAttack(self)
	local tablelength = table.getn(self.SpawnerBuildings)
	if tablelength == 0 then
		if self.dead == false then
			troopspawncounter = troopspawncounter + 10
			destroiedBases = destroiedBases + 1
			GUIQuestTools.UpdateQuestInformationString(destroiedBases .." / "..4)
			self.dead = true
		end
		return true
	end
	local spawnposNow
	for j = tablelength,1,-1 do
		if IsAlive(self.SpawnerBuildings[j][1]) then
			spawnposNow = GetPosition(self.SpawnerBuildings[j][2])
			break;
		else
			table.remove(self.SpawnerBuildings,j)
		end
	end
	if self.SpawnCounter <= 0 then
		Trigger.RequestTrigger(Events.LOGIC_EVENT_EVERY_TURN,nil,"SpawnNVTroops",1,nil,{self,troopspawncountertable[troopspawncounter],spawnposNow})
--[[	local splitter
		for i = 1,troopspawncountertable[troopspawncounter],1 do
			if not splitter then
				self:CreateLeaderForArmy(Entities.CU_Evil_LeaderBearman1, 16, spawnposNow, 3)
			else
				self:CreateLeaderForArmy(Entities.CU_Evil_LeaderSkirmisher1, 16, spawnposNow, 3)
			end
			splitter = not splitter
		end
	]]
		if self.giftreiter >= 6 then
			for i = 1,math.floor(troopspawncounter/10),1 do
				local trooptable = {ID = AI.Entity_CreateFormation(6, Entities.PU_LeaderHeavyCavalry2, nil, 0, spawnposNow.X,spawnposNow.Y, nil, nil, 3,0),PoisonCounter = 2}
				self:AddLeader(trooptable.ID)
				table.insert(giftreiter,trooptable)
			end
			self.giftreiter = 0
		else
			self.giftreiter = self.giftreiter + 1
		end
		self.SpawnCounter = troopspawncooldowntable[troopspawncounter]
	else
		self.SpawnCounter = self.SpawnCounter - 1
	end
	if self:IsIdle() then
		return true, UnlimitedArmy.CreateCommandMove(GetPosition("HQ"))
	end
	return false
end

function SpawnNVTroops(_UA,TroopSpawn,_Place)
	if _UA.troopcounter == TroopSpawn then
		_UA.troopcounter = 0
		return true
	else
		if math.mod(_UA.troopcounter,2) == 1 then
			_UA:CreateLeaderForArmy(Entities.CU_Evil_LeaderBearman1, 16, _Place, 3)
		else
			_UA:CreateLeaderForArmy(Entities.CU_Evil_LeaderSkirmisher1, 16, _Place, 3)
		end
		_UA.troopcounter = _UA.troopcounter + 1
	end
	return false
end